function H = hurst_disp_pub(x,numsteps);
%
% Compute the Hurst parameter for a sequence using the 
% dispersional analysis
%
% maxwin is the maximum window size and should be a power of two
%
%

mn=mean(x);
n=length(x);

bins=x;
rd(1) = std(bins)/mn;

fprintf(1,'%f %f %f\n',1,1,rd(1));


currd=2;
curbin=2;
maxwin=2^numsteps;

while (curbin<=maxwin), 
   num=floor(n/curbin);
   bins(1:1:num) = 0.5* (bins(1:2:2*num) + bins(2:2:2*num));
   rd(currd) = std(bins(1:1:num))/mn;
   fprintf(1,'%f %f %f\n',currd,curbin,rd(currd));
   curbin=2*curbin;
   currd=currd+1;
end;

y=log2(rd);
x=1:length(rd);


mx=mean(x);
my=mean(y);
n=length(y);

b1 = (sum(x.*y) - n*mx*my) / (sum(x.^2) - n*mx^2);
b0 = my - b1*mx;

plot(x,y,'o');
line([x(1),x(n)],[b0,b0+b1*((x(n)-x(1)))]);

H=1+b1;

