function tsa_plot(x,maxlag,lab,arord,ahead)

acfall=xcov(x,maxlag,'coeff');
acf = acfall(maxlag+1:2*maxlag+1);
n = length(x); 
bound95 = 1.96./sqrt(n:-1:n-maxlag);
lags = 0:maxlag;
sigp = 100*sum(abs(acf(2:maxlag))>bound95(2:maxlag))/maxlag;
figure(1);
plot(lags,acf,lags,bound95,'r--',lags,-bound95,'r--');
set(gca,'FontSize',24);
xlabel('Lag');
ylabel('Acf');
t = sprintf('%s - ACF (%g %% sig at p=0.05)',lab,sigp);
title(t);
figure(2);
plot(x);
set(gca,'FontSize',24);
xlabel('time');
ylabel('signal');
t = sprintf('%s - time domain',lab);
title(t);
f = fft(x);
f = f(1:n/2);
figure(3);
plot(abs(f));
set(gca,'FontSize',24);
xlabel('freq');
ylabel('mag');
t = sprintf('%s - FFT (magnitude)',lab);
title(t);
figure(4);
plot(phase(f)*180/pi);
set(gca,'FontSize',24);
%plot(f,'o');
xlabel('freq');
ylabel('phase (degrees)');
t = sprintf('%s - FFT (phase)',lab);
title(t);
figure(5);
histfit(x);
set(gca,'FontSize',24);
xlabel('values');
ylabel('occurances');
t= sprintf('%s - Histogram of data',lab);
title(t);
th=ar(x,arord);
figure(6);
yp = predict(x',th,ahead);
plot(yp,x,'o');
set(gca,'FontSize',24);
xlabel('predictions');
ylabel('values');
t=sprintf('%s AR(%g) %g-step-ahead predictions',lab,arord,ahead);
title(t);

