function H = hurst1(x);
% H = hurst1(x);
% determines the Hurst coefficient of a times series x
% x should be a column vector
% modified by Gerry Middleton, January 1996 from an octave
% function written by Friedrich.Leisch@ci.tuwien.ac.at
% In this version, the input vector is a walk, i.e., the
% cumsum of a noise. hurst3.m appears to be more accurate
% Press <space> to start.
% help hurst1;
% pause;
rows = length(x);
dx = x(2:rows) - x(1:rows-1);
s = std(dx);
xm = mean(dx);
w = (x - xm);           % cumulative sum of deviations from mean
rs = (max(w) - min(w)) /s;      % range/standard deviation
H = log(rs) / log(rows);
