#include <UnitTest++/UnitTest++.h>

#include "geometry.h"

TEST(areaPositiveSides)
{
    CHECK_EQUAL( 10, geometry::area( 2, 5 ) );
    CHECK_EQUAL( 10, geometry::area( 5, 2 ) );
    CHECK_EQUAL( 36, geometry::area( 6, 6 ) );
}

TEST(areaZeroSides)
{
    CHECK_EQUAL( 0, geometry::area( 5, 0 ) );
    CHECK_EQUAL( 0, geometry::area( 0, 5 ) );
    CHECK_EQUAL( 0, geometry::area( 0, 0 ) );
}


TEST(areaNegativeSides)
{
    CHECK_EQUAL( 0, geometry::area( 5, -2 ) );
    CHECK_EQUAL( 0, geometry::area( -2, 5 ) );
    CHECK_EQUAL( 0, geometry::area( -2, -5 ) );
}


int main()
{
    return UnitTest::RunAllTests();
}
